<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    DTR1 - Instance Identifier
    Status: draft
-->
<rule abstract="true" id="II" xmlns="http://purl.oclc.org/dsdl/schematron">
    <extends rule="ANY"/>
    
    <assert role="error" test="@nullFlavor or (not(@nullFlavor) and @root)">dtr1-1-II: @root is required if @nullFlavor is not present</assert>
    <assert role="error" test="not(@nullFlavor) or (@nullFlavor and not(@root))">dtr1-2-II: @root may not be used if @nullFlavor is present</assert>
    <!--assert role="error" test="not(@nullFlavor) or (@nullFlavor and not(@extension))">dtr1-3-II: no @extension if null</assert-->
    
    <assert role="error" test="not(@nullFlavor) or (@nullFlavor and not(@identifierName))">dtr1-4-II: @identifierName may not be used if @nullFlavor is present</assert>
    <assert role="error" test="not(@nullFlavor) or (@nullFlavor and not(@displayable))">dtr1-5-II: @displayable may not be used if @nullFlavor is present</assert>
    <assert role="error" test="not(@nullFlavor) or (@nullFlavor and not(@reliability))">dtr1-6-II: @reliability may not be used if @nullFlavor is present</assert>
    
    <assert role="error" test="not(@nullFlavor) or (@nullFlavor and not(@assigningAuthorityName))">dtr1-7-II: @assigningAuthorityName may not be used if @nullFlavor is present</assert>
    
     <!-- 
        Issue
        DICOM has a max of 64 chars in an OID
        Canada uses 200 chars for OIDs
    -->
    <report role="warning" test="not(string-length(@root) &lt;= 128)">dtr1-8-II: @root should not be longer than 128 characters. Please write a note to the authors of this rule if this is found to be not sufficient</report>
    <report role="warning" test="not(string-length(@extension) &lt;= 64)">dtr1-9-II: @extension should not be longer than 64 characters. Please write a note to the authors of this rule if this is found to be not sufficient</report>

    <!-- Dutch-specific checks -->
    <assert role="error" test="not(@root='2.16.528.1.1007.3.1') or matches(@extension,'^[0-9]{9}$')">Datatype II: UZI-nummer persoon moet 9 cijfers lang
        zijn</assert>

    <!-- Overwegen meer generieke code controles te gaan doen -->
    <let name="codeValue" value="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.111']/@code"/>
    <assert role="error" test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.111.xml')/*/hl7:code[@code=$codeValue]">Datatype II: UZI
        rolcode attribuut code bevat geen geldige RoleCodeNL.</assert>

    <assert role="error" test="not(@root='2.16.528.1.1007.3.2') or matches(@extension,'^[0-9]{9}$')">Datatype II: UZI-nummer systeem moet 9 cijfers lang
        zijn</assert>

    <!-- 
        URA mag 1 zijn, indien het id van de entiteit waar de organisatie bij 
        hoort (bijvoorbeeld een AssignedDevice) het ZIM is.
    -->
    <assert role="error"
        test="not(@root='2.16.528.1.1007.3.3') or (../../hl7:id/@root='2.16.840.1.113883.2.4.6.6' and ../../hl7:id/@extension='1' and @extension='1') or
            matches(@extension,'^[0-9]{8}$')"
        >Datatype II: UZI-registerabonneenummer moet 8 cijfers lang zijn</assert>

    <!-- Overwegen meer generieke code controles te gaan doen -->
    <let name="codeValue" value="../hl7:code[@codeSystem='2.16.840.1.113883.2.4.15.1060']/@code"/>
    <assert role="error" test="string-length($codeValue)=0 or document('../vocab/2.16.840.1.113883.2.4.15.1060.xml')/*/hl7:code[@code=$codeValue]"
        >Datatype II: Organisatie rolcode attribuut code bevat geen geldige AssignedRoleType.</assert>

    <assert role="error" test="not(@root='2.16.840.1.113883.2.4.6.1') or matches(@extension,'^[0-9]{8}$')"
        >Datatype II: AGB-code moet 8 cijfers lang zijn</assert>

    <assert role="error" test="not(@root='2.16.840.1.113883.2.4.6.3') or matches(@extension,'^[0-9]{9}$')"
         >Datatype II: Burgerservicenummer moet 9 cijfers lang zijn</assert>
    <assert role="error"
        test="not(@root='2.16.840.1.113883.2.4.6.3') or (
            (   number(substring(@extension,1,1))*9 )+
            (   number(substring(@extension,2,1))*8 )+
            (   number(substring(@extension,3,1))*7 )+
            (   number(substring(@extension,4,1))*6 )+
            (   number(substring(@extension,5,1))*5 )+
            (   number(substring(@extension,6,1))*4 )+
            (   number(substring(@extension,7,1))*3 )+
            (   number(substring(@extension,8,1))*2 )+
            (   number(substring(@extension,9,1))*-1) ) mod 11=0"
        >Datatype II: Burgerservicenummer voldoet niet aan modulo 11 proef</assert>

    <let name="codeValue" value="@extension"/>
    <assert role="error" test="not(@root='2.16.840.1.113883.1.6') or document(concat('../vocab/',@root,'.xml'))/*/hl7:code[@code=$codeValue]"
        >Datatype II: @extension moet een geldige interactie-id bevatten</assert>
</rule>